//	OTLNp_dmInterface.c

#include "stdio.h"
#include "Carbon68kGlue.h"
#include "OTLNp.h"

#define		kTwirlieResOffset			200
static		PicHandle					S_twirlies[kTotalTwirlies];


void	OTLN_Report(short rtn, const char *format, const char *val)
{
	#ifdef USING_U
		OTLNp_PROB(rtn, (U_Fmt_CUSTOM, format, val));
	#else
		char	bufAC[256];
		
		sprintf(bufAC, format, val);
		OTLNp_PROB_S(rtn, bufAC);
	#endif
}

void	OTLN_Report(short rtn, const char *format, short val)
{
	#ifdef USING_U
		OTLNp_PROB(rtn, (U_Fmt_CUSTOM, format, val));
	#else
		char	bufAC[256];
		
		sprintf(bufAC, format, val);
		OTLNp_PROB_S(rtn, bufAC);
	#endif
}

/**		OTLN_AllocateTwirlies	[22]
**/
Err			OTLN_AllocateTwirlies(void)
{
	Err		err = Err_NONE;
	
	if (S_twirlies[0] == NULL) {
		short			loop;
		
		for (loop = 0; !err && (loop < kTotalTwirlies); loop++) {
		
			S_twirlies[loop] = GetPicture(kTwirlieResOffset + loop);
			
			if (S_twirlies[loop] == NULL) {
				OTLN_Report(22, OTLNp_STR(12), loop);
				err = Err_ALLOC;
			}
		}
	}
	
	return err;
}


/**		OTLN_DisposeTwirlies	[23]
**/
Err			OTLN_DisposeTwirlies(void)
{
	short			loop;

	for (loop = 0; loop <= (kTotalTwirlies - 1); loop++) {
	
		if (S_twirlies[loop] != NULL) {
			ReleaseResource((Handle)S_twirlies[loop]);
			S_twirlies[loop] = NULL;
		}
	}
	
	return Err_NONE;
}


/**		OTLN_BlitArrow		[24]
**/
extern	Boolean	Is_OS_X(void);

Err			OTLN_BlitArrow(short arrow, Rect *destRect)
{
	EraseRect(destRect);
	DrawPicture(S_twirlies[arrow], destRect);

	if (Is_OS_X()) {
//		FlushCurPort();
		GrafPtr		thePort;
		
		GetPort(&thePort);
		QDFlushPortBuffer((CGrafPtr)thePort, NULL);
	}

	return Err_NONE;
}


/**		OTLN_DrawName		[25]
	$$$ slowness warning:
		calling GetFontInfo for each topic drawn may be slow!.  Better to perhaps
		call it once just before DrawIterate and store it inthe OutlineHandle
**/
static	void		OTLNp_ShrinkString(void *theString, int space_for_string)
{
	short length = ((char *)theString)[0];

	if (length > 0) {
		CopyPascalStringToC((unsigned char *)theString, (char *)theString);

		TruncText(space_for_string, (char *)theString, &length, truncEnd);
		
		// TruncText doesn't actually do the truncation
		//  (but it does add the ellipsis)
		((char *)theString)[length] = 0;
	
		CopyCStringToPascal((char*)theString, (unsigned char *)theString);
	}
}

Err			OTLN_DrawName(OTLN_OutlineP ol, OTLN_TopicP to, Rect *theRect)
{
	Str255		string;
	FontInfo	finfo;
	Style		face;
	CGrafPtr	thePort;
	
	GetPort((GrafPtr *)&thePort);
	face = GetPortTextFace(thePort);	

	//	set the style so stringwidth works
	TextFace(to->font_style);

	//	prepare the string
	strcpy((char *)string, to->name);
	
	if (OTLN_IS_TopicFlag_SET(OTLN_GET_TopicP_FLAGS(to), OTLN_TopicFlags_HAS_NUMBER)) {
		char	temp[256];
		
		sprintf(temp, "%d: %s", to->topicNumber, string);
		strcpy((char *)string, temp);
	}
		
	CopyCStringToPascal((char *)string, string);
	OTLNp_ShrinkString(string, (theRect->right - theRect->left) - 1);

	//	draw the name
	GetFontInfo(&finfo);
	MoveTo(theRect->left + 1, theRect->top + finfo.ascent - 1);
	DrawString(string);

/*	
	MoveTo(theRect->left + 1, theRect->top + finfo.ascent - 1);
	LineTo(theRect->right, theRect->top + finfo.ascent - 1);
	FrameRect(theRect);
*/
	
	//	invert name if selected
	if (OTLN_IS_TopicFlag_SET(OTLN_GET_TopicP_FLAGS(to), OTLN_TopicFlags_IS_SELECTED)) {
		// BCLR	#hiliteBit, HiliteMode;
		LMSetHiliteMode(LMGetHiliteMode() & (~(1 << hiliteBit)));
		(theRect->bottom)--;
		(theRect->left)--;
		InvertRect(theRect);
		(theRect->bottom)++;
		(theRect->left)++;
	}
	
	//	set the style back to what it was
	TextFace(face);
	
	return Err_NONE;
}

static	void		OTLNp_PlotMIconHandle(Handle iconHandle, short listID, short hPos, short vPos)
{
/*
	BitMap		iconMap;
	Rect		destRect;
	long		myGray[2];

	destRect.top = destRect.left = 0;
	destRect.bottom = destRect.right = 10;
	iconMap.bounds = destRect;
	OffsetRect(&destRect, hPos, vPos);

	if (iconHandle != NULL) {
		LoadResource(iconHandle);
		HLock(iconHandle);
		iconMap.baseAddr	= *iconHandle + (32 * listID);
		iconMap.rowBytes	= 2;
		CopyBits(&iconMap, &qd.thePort->portBits, &iconMap.bounds, &destRect, srcCopy, NULL);
		HUnlock(iconHandle);
	} else {
		myGray[0] = myGray[1] = 0xAA55AA55;
		FillRect(&destRect, (ConstPatternParam)&myGray);
	}
*/
}



/**		OTLN_BlitIcon		[26]
**/
Err			OTLN_BlitIcon(OTLN_OutlineP ol, short iconRef, Rect *inHere)
{
	OTLNp_PlotMIconHandle((Handle)ol->iconsH, iconRef, inHere->left, inHere->top);

	return Err_NONE;
}


/**		OTLN_SaveSetFontInfo		[40]
**/
Err			OTLN_SaveSetFontInfo(OTLN_OutlineH outline, OTLN_SaveFontInfo *sfi)
{
	CGrafPtr	thePort;
	
	GetPort((GrafPtr *)&thePort);
	sfi->font	= GetPortTextFont(thePort);	
	sfi->size	= GetPortTextSize(thePort);	
	sfi->style	= GetPortTextFace(thePort);	

	TextFont((**outline).font_id);
	TextSize((**outline).font_size);
	TextFace(normal);
	
	return Err_NONE;
}


/**		OTLN_RestoreFontInfo		[41]
**/
Err			OTLN_RestoreFontInfo(OTLN_SaveFontInfo *sfi)
{
	TextFont(sfi->font);
	TextSize(sfi->size);
	TextFace(sfi->style);
	
	return Err_NONE;
}

